﻿<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>Raport sprzedaży</title>
		<script runat="server"> 

			public class ParametryContext : ContextBase
			{
				public ParametryContext(Context cx)
					: base(cx)
				{
				}

				private bool _ignorujZaliczkowe = true;

				[Soneta.Tools.Priority(10)]
				public bool IgnorujZaliczkowe
				{
					get
					{
						return this._ignorujZaliczkowe;
					}
					set
					{
						this._ignorujZaliczkowe = value;
						OnChanged(EventArgs.Empty);
					}
				}

                private bool ukryjTowaryZIlościąZero = false;
                
                [Caption("Ukryj towary z ilością 0")]
                public bool UkryjTowaryZIlościąZero {
                    get {
                        return ukryjTowaryZIlościąZero;
                    }
                    set {
                        ukryjTowaryZIlościąZero = value;
                    }
                }

			}

			ParametryContext parametry;

			[Context]
			public ParametryContext Parametry
			{
				get { return parametry; }
				set { parametry = value; }
			}
	
    public class Total: IComparable {
        readonly Towar towar;
        double ilość;
        decimal netto;
        public Total(Towar towar) {
            this.towar = towar;
        }
        SumaPozycjiWorker spw = new SumaPozycjiWorker();
        public void Add(PozycjaDokHandlowego pozycja) {
            spw.Pozycja = pozycja;
            netto += spw.Netto;
            ilość += pozycja.ZmianaMagazynu.Ilość.Value;
        }
        public Towar Towar {
            get { return towar; }
        }
        public decimal Netto {
            get { return netto; }
        }
        public double Ilość {
            get { return ilość; }
        }
        public double ŚredniaCena {
            get { return Soneta.Tools.Math.Round((double)netto/ilość, Towar.Precyzja); }
        }
        public int CompareTo(object obj) {
            Total t = (Total)obj;
            return Towar.Nazwa.CompareTo(t.Towar.Nazwa);
        }
    }
    
    void OnContextLoad(Object sender, EventArgs args) {

        PrzecenaOkresowa przecena = dc[typeof(PrzecenaOkresowa)] as PrzecenaOkresowa;        
        Soneta.Business.View doks = null;
        
        ReportHeader.Title += "|Typ: <strong>" + przecena.Typ.ToString() + "</strong>";  
        switch(przecena.Typ){
            case TypPrzecenyOkresowej.Indywidualna:
                ReportHeader.Title += "|Kontrahent: <strong>" + przecena.Kontrahent.ToString() + "</strong>";
                doks = HandelModule.GetInstance(przecena).DokHandlowe.WgKontrahent[przecena.Kontrahent].CreateView();
                break;
            case TypPrzecenyOkresowej.GrupyKontrahnetów:
                ReportHeader.Title += "|Cecha: <strong>" + przecena.GrupaKontrahentow.ToString() + "</strong>";
                ReportHeader.Title += "|Wartość: <strong>" + przecena.GrupaKontrahentowWartosc + "</strong>";                
                break;
        }
        
        if(doks == null)
            doks = HandelModule.GetInstance(przecena).DokHandlowe.WgDaty.CreateView();
        
        RowCondition cond = new FieldCondition.Equal("Kategoria", KategoriaHandlowa.Sprzedaż) 
            | new FieldCondition.Equal("Kategoria", KategoriaHandlowa.KorektaSprzedaży);
        
        
        cond &= new FieldCondition.GreaterEqual("Data", przecena.Okres.From) & new FieldCondition.LessEqual("Data", przecena.Okres.To);

        if (przecena.Typ == TypPrzecenyOkresowej.GrupyKontrahnetów)
        {
            cond &= new FieldCondition.Equal("Kontrahent.Features."+przecena.GrupaKontrahentow.Name, przecena.GrupaKontrahentowWartosc);
        }
        
        doks.Condition = cond;
                        
        Hashtable result = new Hashtable();
        foreach (DokumentHandlowy dokument in doks) {
            
			if (dokument.Anulowany) continue;
			if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
			if (dokument.Definicja.DuplikatWartosci) continue;
            
            foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje)
            {
                PrzecenaOkresowaTowaru pot = null;
                if ((pot = przecena.PrzecenaTowaru(pozycja.Towar)) != null)
                {
                    DoubleCy cenaPozycji = pozycja.Cena;
                    DoubleCy cenaPrzeceny = pozycja.Dokument.LiczonaOd == SposobLiczeniaVAT.OdNetto ? pot.Netto : pot.Brutto;
                    if (cenaPozycji == cenaPrzeceny)
                    {
                        Total t = (Total)result[pozycja.Towar];
                        if (t == null)
                        {
                            t = new Total(pozycja.Towar);
                            result.Add(t.Towar, t);
                        }
                        t.Add(pozycja);
                    }
                }
            }
        }
    
        ArrayList lista = new ArrayList(result.Values);
        lista.Sort();
        Grid.DataSource = lista;
                
    }

    public void Grid_BeforeRow( object sender, RowEventArgs args ) {
        Total t = (Total)args.Row;
        if (Parametry.UkryjTowaryZIlościąZero && t.Ilość == 0 && t.Netto == 0 && t.ŚredniaCena.Equals(Double.NaN))
        {
            args.VisibleRow = false;
        }
    }        

        </script>
		<meta content="C#" name="CODE_LANGUAGE" />
		<meta content="JavaScript" name="vs_defaultClientScript" />
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form method="post" runat="server" action="#">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad" TypeName="Soneta.Towary.PrzecenaOkresowa,Soneta.Handel"></ea:DataContext>
			
            <eb:ReportHeader id="ReportHeader" title="Raport sprzedaży wg przeceny {0}|Okres: {1}"
				runat="server" DataMember0="Nazwa" DataMember1="Okres"></eb:ReportHeader>

			<ea:Grid id="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel" OnBeforeRow="Grid_BeforeRow">
				<Columns>
					<ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="LP." runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn DataMember="Towar.Nazwa" Caption="Towar" NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="15" DataMember="Towar.Kod" Caption="Kod" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Ilość" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="8" Align="Center" DataMember="Towar.Jednostka" Total="Sum" Caption="jm."
						NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="15" Align="Right" DataMember="Netto" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
					<ea:GridColumn Width="14" Align="Right" DataMember="ŚredniaCena" Caption="Średnia cena" Format="{0:n}" runat="server" EncodeHTML="True"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server" TheEnd="False"></eb:ReportFooter>
		</form>
	</body>
</html>

